/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.PlayerData;

public class Bank {
    public final Map<Integer, CeilSettings> ceilSettings = new TreeMap<Integer, CeilSettings>();
    public final List<String> access = new ArrayList<String>();
    public boolean isPublic = false;
    public boolean isWhiteList = false;
    public boolean isChanging = true;
    public int id = -1;
    public String name = "Default Bank";
    public String owner = "";
    private BankData lastBank;

    public Bank() {
        for (int ceil = 0; ceil < 2; ++ceil) {
            CeilSettings cs = new CeilSettings();
            cs.ceil = ceil;
            if (ceil == 1) {
                cs.startCells = 9;
                cs.maxCells = 27;
                cs.openStack = new ItemStack(Items.field_151045_i, 1, 0);
                cs.upgradeStack = new ItemStack(Items.field_151043_k, 2, 0);
            } else {
                cs.startCells = 27;
                cs.maxCells = 54;
                cs.upgradeStack = new ItemStack(Items.field_151043_k, 1, 0);
            }
            this.ceilSettings.put(ceil, cs);
        }
    }

    public CeilSettings addCeil() {
        CeilSettings cs = new CeilSettings();
        cs.ceil = this.ceilSettings.size();
        this.ceilSettings.put(cs.ceil, cs);
        if (CustomNpcs.Server != null) {
            boolean save = false;
            for (String username : CustomNpcs.Server.func_71213_z()) {
                EntityPlayerMP player = CustomNpcs.Server.func_184103_al().func_152612_a(username);
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (player != null && player.field_71070_bA instanceof ContainerNPCBank && ((ContainerNPCBank)player.field_71070_bA).bank.id == this.id) {
                    player.func_71128_l();
                    if (!this.isPublic || !save) {
                        BankData bd = PlayerData.get((EntityPlayer)player).bankData.get(this.id);
                        if (bd != null) {
                            bd.save();
                        }
                        save = true;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.changed", new Object[0]));
                }
                if (data.bankData.lastBank == null || data.bankData.lastBank.bank.id != this.id) continue;
                data.bankData.lastBank = null;
            }
            if (this.isPublic) {
                File banksDir = CustomNpcs.getWorldSaveDirectory("banks");
                File fileBank = new File(banksDir, this.id + ".dat");
                BankData bd = new BankData(this, "");
                try {
                    bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
                if (!bd.cells.containsKey(cs.ceil)) {
                    bd.cells.put(cs.ceil, new NpcMiscInventory(0));
                    bd.save();
                }
            } else {
                File datasDir = CustomNpcs.getWorldSaveDirectory("playerdata");
                if (datasDir == null) {
                    return null;
                }
                for (File playerDir : Objects.requireNonNull(datasDir.listFiles())) {
                    if (!playerDir.isDirectory()) continue;
                    for (File banksDir : Objects.requireNonNull(playerDir.listFiles())) {
                        if (!banksDir.isDirectory() || !banksDir.getName().equals("banks")) continue;
                        File fileBank = new File(banksDir, this.id + ".dat");
                        BankData bd = new BankData(this, playerDir.getName());
                        try {
                            bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
                        }
                        catch (IOException e) {
                            LogWriter.error(e);
                        }
                        if (bd.cells.containsKey(cs.ceil)) continue;
                        bd.cells.put(cs.ceil, new NpcMiscInventory(0));
                        bd.save();
                    }
                }
            }
        }
        return cs;
    }

    public void clearBankData() {
        this.lastBank = null;
    }

    public BankData getBankData() {
        if (this.lastBank != null) {
            return this.lastBank;
        }
        File dir = CustomNpcs.getWorldSaveDirectory("banks");
        File file = new File(dir, this.id + ".dat");
        this.lastBank = new BankData(this, "");
        if (!file.exists()) {
            try {
                file.createNewFile();
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.lastBank.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                LogWriter.error(e);
                this.lastBank = null;
                return null;
            }
        }
        try {
            this.lastBank.setNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            LogWriter.error(e);
            this.lastBank = null;
            return null;
        }
        if (this.lastBank.cells.isEmpty()) {
            this.lastBank.clear();
        }
        return this.lastBank;
    }

    public boolean hasBankData() {
        return this.lastBank != null;
    }

    public void readFromNBT(NBTTagCompound nbtBank) {
        PlayerDataController pData;
        this.id = nbtBank.func_74762_e("BankID");
        this.name = nbtBank.func_74779_i("Username");
        this.ceilSettings.clear();
        this.access.clear();
        String pldOwner = this.owner;
        if (nbtBank.func_150297_b("StartSlots", 3)) {
            this.isPublic = false;
            this.isWhiteList = false;
            this.isChanging = true;
            int maxCells = nbtBank.func_74762_e("MaxSlots");
            NpcMiscInventory oldCInv = new NpcMiscInventory(maxCells);
            NpcMiscInventory oldUInv = new NpcMiscInventory(maxCells);
            oldCInv.load(nbtBank.func_74775_l("BankCurrency"));
            oldUInv.load(nbtBank.func_74775_l("BankUpgrade"));
            for (int ceil = 0; ceil < oldCInv.func_70302_i_(); ++ceil) {
                CeilSettings cs = new CeilSettings();
                cs.ceil = ceil;
                cs.openStack = oldCInv.func_70301_a(ceil);
                cs.upgradeStack = oldUInv.func_70301_a(ceil);
                cs.upgradeStack.func_190920_e(1);
                cs.startCells = 27;
                cs.maxCells = cs.upgradeStack.func_190926_b() ? 27 : 54;
                this.ceilSettings.put(ceil, cs);
            }
        } else {
            NBTTagList list = nbtBank.func_150295_c("BankCells", 10);
            if (list.func_74745_c() == 0 && nbtBank.func_150297_b("BankCeils", 9)) {
                list = nbtBank.func_150295_c("BankCeils", 10);
            }
            for (int ceil = 0; ceil < list.func_74745_c(); ++ceil) {
                this.ceilSettings.put(ceil, new CeilSettings(list.func_150305_b(ceil)));
            }
            this.isPublic = nbtBank.func_74767_n("IsPublic");
            this.isWhiteList = nbtBank.func_74767_n("IsWhiteList");
            if (nbtBank.func_150297_b("IsChanging", 1)) {
                this.isChanging = nbtBank.func_74767_n("IsChanging");
            }
            this.owner = nbtBank.func_74779_i("Owner");
            list = nbtBank.func_150295_c("BankNamesPlayersAccess", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.access.add(list.func_150307_f(i));
            }
        }
        if ((pData = PlayerDataController.instance) != null) {
            List<String> names = PlayerDataController.instance.getPlayerNames();
            if (!this.owner.isEmpty() && !names.contains(this.owner)) {
                boolean notFound = true;
                for (String name : names) {
                    if (!name.equalsIgnoreCase(this.owner)) continue;
                    this.owner = name;
                    notFound = false;
                    break;
                }
                if (notFound) {
                    this.owner = pldOwner;
                }
            }
            if (!this.access.isEmpty()) {
                ArrayList<String> newAccess = new ArrayList<String>();
                boolean isChanged = false;
                block4: for (String ac : this.access) {
                    if (!names.contains(ac)) {
                        for (String name : names) {
                            if (!name.equalsIgnoreCase(ac)) continue;
                            newAccess.add(name);
                            isChanged = true;
                            continue block4;
                        }
                        continue;
                    }
                    newAccess.add(ac);
                }
                if (this.access.size() != newAccess.size() || isChanged) {
                    this.access.clear();
                    this.access.addAll(newAccess);
                }
            }
            if (!this.access.isEmpty()) {
                Collections.sort(this.access);
            }
        }
    }

    public void removeCeil(int ceilId) {
        if (!this.ceilSettings.containsKey(ceilId)) {
            return;
        }
        if (CustomNpcs.Server != null) {
            boolean save = false;
            for (String username : CustomNpcs.Server.func_71213_z()) {
                EntityPlayerMP player = CustomNpcs.Server.func_184103_al().func_152612_a(username);
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (player != null && player.field_71070_bA instanceof ContainerNPCBank && ((ContainerNPCBank)player.field_71070_bA).bank.id == this.id) {
                    player.func_71128_l();
                    if (!this.isPublic || !save) {
                        BankData bd = PlayerData.get((EntityPlayer)player).bankData.get(this.id);
                        if (bd != null) {
                            bd.save();
                        }
                        save = true;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.changed", new Object[0]));
                }
                if (data.bankData.lastBank == null || data.bankData.lastBank.bank.id != this.id) continue;
                data.bankData.lastBank = null;
            }
            if (this.isPublic) {
                File banksDir = CustomNpcs.getWorldSaveDirectory("banks");
                File fileBank = new File(banksDir, this.id + ".dat");
                BankData bd = new BankData(this, "");
                try {
                    bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
                TreeMap<Integer, NpcMiscInventory> newCells = new TreeMap<Integer, NpcMiscInventory>();
                int i = 0;
                for (NpcMiscInventory inv : bd.cells.values()) {
                    if (i == ceilId) continue;
                    newCells.put(i, inv);
                    ++i;
                }
                bd.cells.clear();
                bd.cells.putAll(newCells);
                bd.save();
            } else {
                File datasDir = CustomNpcs.getWorldSaveDirectory("playerdata");
                if (datasDir == null) {
                    return;
                }
                for (File playerDir : Objects.requireNonNull(datasDir.listFiles())) {
                    if (!playerDir.isDirectory()) continue;
                    for (File banksDir : Objects.requireNonNull(playerDir.listFiles())) {
                        if (!banksDir.isDirectory() || !banksDir.getName().equals("banks")) continue;
                        File fileBank = new File(banksDir, this.id + ".dat");
                        BankData bd = new BankData(this, playerDir.getName());
                        try {
                            bd.readNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(fileBank.toPath(), new OpenOption[0])));
                        }
                        catch (IOException e) {
                            LogWriter.error(e);
                        }
                        TreeMap<Integer, NpcMiscInventory> newCells = new TreeMap<Integer, NpcMiscInventory>();
                        int i = 0;
                        for (int c : bd.cells.keySet()) {
                            if (c == ceilId) continue;
                            newCells.put(i, bd.cells.get(c));
                            ++i;
                        }
                        bd.cells.clear();
                        bd.cells.putAll(newCells);
                        bd.save();
                    }
                }
            }
        }
        TreeMap<Integer, CeilSettings> newCS = new TreeMap<Integer, CeilSettings>();
        int i = 0;
        File[] fileArray = this.ceilSettings.keySet().iterator();
        while (fileArray.hasNext()) {
            int c = fileArray.next();
            if (c == ceilId || this.ceilSettings.get((Object)Integer.valueOf((int)c)).ceil == ceilId) continue;
            this.ceilSettings.get((Object)Integer.valueOf((int)c)).ceil = i;
            newCS.put(i, this.ceilSettings.get(c));
            ++i;
        }
        this.ceilSettings.clear();
        this.ceilSettings.putAll(newCS);
        BankController.getInstance().saveBank(this);
    }

    public void writeToNBT(NBTTagCompound nbtBank) {
        nbtBank.func_74768_a("BankID", this.id);
        nbtBank.func_74778_a("Username", this.name);
        nbtBank.func_74757_a("IsPublic", this.isPublic);
        nbtBank.func_74757_a("IsWhiteList", this.isWhiteList);
        nbtBank.func_74757_a("IsChanging", this.isChanging);
        nbtBank.func_74778_a("Owner", this.owner);
        if (this.name.isEmpty()) {
            this.name = "Default Bank";
        }
        NBTTagList listCS = new NBTTagList();
        for (int ceil = 0; ceil < this.ceilSettings.size(); ++ceil) {
            NBTTagCompound nbtCeil = new NBTTagCompound();
            nbtCeil.func_74768_a("Ceil", ceil);
            this.ceilSettings.get(ceil).writeTo(nbtCeil);
            listCS.func_74742_a((NBTBase)nbtCeil);
        }
        nbtBank.func_74782_a("BankCells", (NBTBase)listCS);
        NBTTagList listNPA = new NBTTagList();
        for (String n : this.access) {
            listNPA.func_74742_a((NBTBase)new NBTTagString(n));
        }
        nbtBank.func_74782_a("BankNamesPlayersAccess", (NBTBase)listNPA);
    }

    public static class CeilSettings {
        public ItemStack openStack = ItemStack.field_190927_a;
        public ItemStack upgradeStack = ItemStack.field_190927_a;
        public int openMoney = 0;
        public int upgradeMoney = 0;
        public int ceil = 0;
        public int startCells = 1;
        public int maxCells = 27;

        public CeilSettings() {
        }

        public CeilSettings(NBTTagCompound nbtCeil) {
            this.read(nbtCeil);
        }

        public void read(NBTTagCompound nbtCeil) {
            this.openStack = nbtCeil.func_150297_b("CeilCurrency", 10) ? new ItemStack(nbtCeil.func_74775_l("CeilCurrency")) : ItemStack.field_190927_a;
            this.upgradeStack = nbtCeil.func_150297_b("CeilUpgrade", 10) ? new ItemStack(nbtCeil.func_74775_l("CeilUpgrade")) : ItemStack.field_190927_a;
            this.startCells = nbtCeil.func_74762_e("StartCeil");
            this.maxCells = nbtCeil.func_74762_e("MaxCeil");
            this.ceil = nbtCeil.func_74762_e("CeilId");
            this.upgradeMoney = nbtCeil.func_74762_e("CeilUpgradeMoney");
            this.openMoney = nbtCeil.func_74762_e("CeilCurrencyMoney");
        }

        public void set(CeilSettings settings) {
            this.openStack = settings.openStack;
            this.upgradeStack = settings.upgradeStack;
            this.openMoney = settings.openMoney;
            this.upgradeMoney = settings.upgradeMoney;
            this.startCells = settings.startCells;
            this.maxCells = settings.maxCells;
        }

        public void writeTo(NBTTagCompound nbtCeil) {
            if (this.openStack != null && !this.openStack.func_190926_b()) {
                nbtCeil.func_74782_a("CeilCurrency", (NBTBase)this.openStack.func_77955_b(new NBTTagCompound()));
            }
            if (this.upgradeStack != null && !this.upgradeStack.func_190926_b()) {
                nbtCeil.func_74782_a("CeilUpgrade", (NBTBase)this.upgradeStack.func_77955_b(new NBTTagCompound()));
            }
            nbtCeil.func_74768_a("StartCeil", this.startCells);
            nbtCeil.func_74768_a("MaxCeil", this.maxCells);
            nbtCeil.func_74768_a("CeilId", this.ceil);
            nbtCeil.func_74768_a("CeilUpgradeMoney", this.upgradeMoney);
            nbtCeil.func_74768_a("CeilCurrencyMoney", this.openMoney);
        }
    }
}

